function u = setBvControlRules(m)
%SETBVCONTROLRULES Set control rules for the Vanthoor greenhouse model.
% Must be used after the params, controls, states, and aux states have been
% defined.
% Inputs:
%   m       a StateSpaceModel object to be used as a Vanthoor model.
% Outputs:
%   u       a struct of DynamicElements to be used as the controls for m
%           i.e., to be placed as m.u

% David Katzin, Wageningen University
% david.katzin@wur.nl

    %% set shorthands for easier reading
    p = m.p; 
    x = m.x;
    a = m.a;
    d = m.d;
    u = m.u;
	
    u.shScr.def = '0'; % shading screen is always open (doesn't exist)
    u.shScrPer.def = '0'; % permanent shading screen is always open (doesn't exist)
    u.side.def = '0'; % side ventilation is always closed (doesn't exist)
    u.blScr.def = '0'; % blackout screen is always open (doesn't exist)

    
    % Heating from boiler [0 is no heating, 1 is full heating]
    u.boil = proportionalControl(x.tAir, a.heatSetPoint, p.tHeatBand, 0, 1);
    
    % Heating to grow pipes [0 is no heating, 1 is full heating]
    u.groBoil = proportionalControl(x.tAir, a.heatSetPoint, p.tHeatBand, 0, 1);

    % External CO2 supply [0 is no supply, 1 is full supply]
    u.extCo2 = proportionalControl(a.co2InPpm, a.co2SetPoint, p.co2Band, 0, 1);
    
    % Ventilation from the roof [0 is windows fully closed, 1 is fully open]
    u.roof = min(a.ventCold, max(a.ventHeat,a.ventRh));
    
    % Lighting from the top lights [W m^{-2}]
    u.lamp = a.lampOn;
    
    % Lighting from the interlights [W m^{-2}]
    u.intLamp = a.lampOn;

    % Thermal screen [0 is open, 1 is closed]
    u.thScr = max(a.thScrCold,min(a.ventThScr,a.thScrHeat));

    % set initial values
    u.boil.val = 0;
    u.groBoil.val = 0;
    u.extCo2.val = 0;
    u.shScr.val = 0;
    u.shScrPer.val = 0;
    u.thScr.val = 1;
    u.roof.val = 0;
    u.side.val = 0;
    u.lamp.val = 0;
    u.intLamp.val = 0;
    u.blScr.val = 0;
end